/*
 * @(#)AbstractElement.java  2.1  2006-03-20
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.simulation;

import javax.swing.event.*;
import java.util.*;
import java.beans.*;
/**
 * AbstractElement.
 *
 *
 * @author Werner Randelshofer
 * @version 2.1 2006-03-20 Method getSimulatedElements(int) added.
 * <br>2.0 2006-02-15 Upgraded to Java 1.5 type safe collectins.
 * <br>1.0 2. Dezember 2003  Created.
 */
public abstract class AbstractElement
        extends AbstractObject
        implements SimulatedElement {
    
    private LinkedList<SimulatedRelationship> connections;
    
    /** Creates a new instance. */
    public AbstractElement() {
    }
    
    // CONNECTION SUPPORT
    public void addRelationship(SimulatedRelationship connection) {
        if (connections == null) connections = new LinkedList<SimulatedRelationship>();
        connections.add(connection);
        fireRelationshipAdded(connection);
    }
    
    public void removeRelationship(SimulatedRelationship connection) {
        if (connections != null) {
            connections.remove(connection);
        }
    }
    
    public List<SimulatedRelationship> getRelationships() {
        return (connections == null) ? Collections.EMPTY_LIST : Collections.unmodifiableList(connections);
    }
    public List<SimulatedElement> getRelatedElements() {
        LinkedList<SimulatedElement> list = new LinkedList<SimulatedElement>();
        for (SimulatedRelationship c : getRelationships()) {
            list.add(c.getConnected(this));
        }
        return list;
    }
    public List<SimulatedElement> getRelatedElements(int simulatedConcept) {
        LinkedList<SimulatedElement> list = new LinkedList<SimulatedElement>();
        for (SimulatedRelationship c : getRelationships()) {
            if (c.getConnected(this).getSimulatedConcept() == simulatedConcept) {
                list.add(c.getConnected(this));
            }
        }
        return list;
    }
    
    public boolean canConnect() {
        return true;
    }
    
    // LISTENER SUPPORT
    /**
     * Notify all listeners that have registered interest for
     * notification on this event type.  The event instance
     * is lazily created using the parameters passed into
     * the fire method.
     */
    protected void fireRelationshipAdded(SimulatedRelationship connection) {
        if (listenerList != null) {
            SimulatedObjectEvent event = null;
            
            // Guaranteed to return a non-null array
            Object[] listeners = listenerList.getListenerList();
            // Process the listeners last to first, notifying
            // those that are interested in this event
            for (int i = listeners.length-2; i>=0; i-=2) {
                if (listeners[i]==SimulatedObjectListener.class) {
                    // Lazily create the event:
                    if (event == null)
                        event = new SimulatedObjectEvent(this, connection);
                    ((SimulatedObjectListener)listeners[i+1]).relationshipAdded(event);
                }
            }
        }
    }
    
    /**
     * Creates a shallow copy of this element.
     */
    public AbstractElement clone() {
        AbstractElement that = (AbstractElement) super.clone();
        that.connections = null;
        return that;
    }
    
    public List<SimulatedRelationship> getRelationships(int simulatedConcept) {
        List<SimulatedRelationship> list = new ArrayList<SimulatedRelationship>();
        if (connections != null) {
            for (Iterator i = connections.iterator(); i.hasNext(); ) {
                SimulatedRelationship c = (SimulatedRelationship) i.next();
                if (c.getSimulatedConcept() == simulatedConcept) {
                    list.add(c);
                }
            }
        }
        return list;
    }
}
